use v5.42;
use experimental 'class';

# NAME
# ====
#
# Daje::Workflow::Loader - Just loads Daje-Workflow JSON based workflows
#
#
# SYNOPSIS
# ========
#
#    use Daje::Workflow::Loader;
#
#    my $workflows = Daje::Workflow::Loader->new(
#         path => $path,
#         type => 'workflow',
#    )->load();
#
#    my $workflow = $workflows->loader->get_workflow('workflow');
#
#    my $state = $workflows->loader->get_state('workflow','state');
#
#    my $pre_checks = $workflows->loader->get_pre_checks('workflow','state');
#
#    my $post_checks = $workflows->loader->get_post_checks('workflow','state');
#
#    my $activity =  $workflows->loader->get_activity($workflow, $state_name, $activity_name);
#
# DESCRIPTION
# ===========
#
# Daje::Workflow::Loader is a workflow loader for
#
# the Daje-Workflow engine
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

class Daje::Workflow::Loader {

    field $path :param;
    field $type :param :reader;
    field $error :reader;
    field $has_error :reader = 0;
    field $loader :reader;
    field $analyser :reader;

    use Daje::Workflow::Roadmap::Load;;
    use Daje::Workflow::Details::Analyser;

    our $VERSION = "0.13";

    method load() {

        $self->_load();
        if($has_error == 0) {
            $self->_analyser();
        }
        return 1;
    }

    method _analyser() {
        try {
            $analyser = Daje::Workflow::Details::Analyser->new(
                loader => $loader,
            );
            $analyser->analyze();
        } catch ($e) {
            $self->add_error($e);
        };
    }

    method _load() {
        try {
            $loader = Daje::Workflow::Roadmap::Load->new(
                type => $type,
                path => $path,
            );
            $loader->load();
        } catch($e) {
            $self->add_error($e);
        };
    }

    method add_error( $new_error =  "") {
        return 1 unless length($new_error) > 0;

        my $err = $error;
        $err = "" unless $err;
        $error = $err . ' ' . $new_error;
        $has_error = 1;
    }
}

# Load the data into the object

1;
__END__
















#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Loader - Just loads Daje-Workflow JSON based workflows




=head1 SYNOPSIS


   use Daje::Workflow::Loader;

   my $workflows = Daje::Workflow::Loader->new(
        path => $path,
        type => 'workflow',
   )->load();

   my $workflow = $workflows->loader->get_workflow('workflow');

   my $state = $workflows->loader->get_state('workflow','state');

   my $pre_checks = $workflows->loader->get_pre_checks('workflow','state');

   my $post_checks = $workflows->loader->get_post_checks('workflow','state');

   my $activity =  $workflows->loader->get_activity($workflow, $state_name, $activity_name);



=head1 DESCRIPTION


Daje::Workflow::Loader is a workflow loader for

the Daje-Workflow engine



=head1 REQUIRES

L<Daje::Workflow::Loader> 

L<Daje::Workflow::Details::Analyser> 

L<Daje::Workflow::Roadmap::Load> 

L<experimental> 

L<v5.42> 


=head1 METHODS


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

