use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME             => 'Ancient',
    DISTNAME         => 'Ancient',
    VERSION          => '0.08',
    ABSTRACT         => 'Ancient Perl',
    MIN_PERL_VERSION => '5.014',
    AUTHOR       => 'LNATION <email@lnation.org>',
    LICENSE      => 'perl_5',
    macro        => { TARFLAGS => "--format=ustar -c -v -f" },
    DIR          => [qw(xs/slot xs/util xs/noop xs/const xs/doubly xs/object xs/lru xs/heap)],
    META_MERGE   => {
        'meta-spec' => { version => 2 },
        provides => {
            'Ancient' => {
                file    => 'lib/Ancient.pm',
                version => '0.08',
            },
            'heap' => {
                file    => 'lib/heap.pm',
                version => '0.08',
            },
        },
    },
);
