package Daje::Controller::ToolsTreelist;
use Mojo::Base 'Mojolicious::Controller', -signatures;
use v5.40;


# NAME
# ====
#
# Daje::Controller::Tools - Mojolicious Plugin
#
# SYNOPSIS
# ========
#
#
#
# DESCRIPTION
# ===========
#
# Daje::Controller::Tools is a Mojolicious plugin.
#
# METHODS
# =======
#
# Register plugin in L<Mojolicious> application.
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.com
#

sub load_treelist($self) {

    $self->app->log->debug('Daje::Controller::ToolsTreelist::load_treelist');
    $self->render_later;
    my $tools_projects_pkey = $self->param('tools_projects_pkey');

    $self->tools_helper_treelist->load_treelist($tools_projects_pkey)->then(sub ($result){
        $self->render(json => $result->{data});
    })->catch(sub ($err) {
        $self->render(json => { 'result' => 'failed', data => $err });
    });
}

1;