# Generated by default/object.tt
package Paws::Shield::ProtectionGroup;
  use Moose;
  has Aggregation => (is => 'ro', isa => 'Str', required => 1);
  has Members => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has Pattern => (is => 'ro', isa => 'Str', required => 1);
  has ProtectionGroupArn => (is => 'ro', isa => 'Str');
  has ProtectionGroupId => (is => 'ro', isa => 'Str', required => 1);
  has ResourceType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Shield::ProtectionGroup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Shield::ProtectionGroup object:

  $service_obj->Method(Att1 => { Aggregation => $value, ..., ResourceType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Shield::ProtectionGroup object:

  $result = $service_obj->Method(...);
  $result->Att1->Aggregation

=head1 DESCRIPTION

A grouping of protected resources that you and AWS Shield Advanced can
monitor as a collective. This resource grouping improves the accuracy
of detection and reduces false positives.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Aggregation => Str

Defines how AWS Shield combines resource data for the group in order to
detect, mitigate, and report events.

=over

=item *

Sum - Use the total traffic across the group. This is a good choice for
most cases. Examples include Elastic IP addresses for EC2 instances
that scale manually or automatically.

=item *

Mean - Use the average of the traffic across the group. This is a good
choice for resources that share traffic uniformly. Examples include
accelerators and load balancers.

=item *

Max - Use the highest traffic from each resource. This is useful for
resources that don't share traffic and for resources that share that
traffic in a non-uniform way. Examples include CloudFront distributions
and origin resources for CloudFront distributions.

=back



=head2 B<REQUIRED> Members => ArrayRef[Str|Undef]

The Amazon Resource Names (ARNs) of the resources to include in the
protection group. You must set this when you set C<Pattern> to
C<ARBITRARY> and you must not set it for any other C<Pattern> setting.


=head2 B<REQUIRED> Pattern => Str

The criteria to use to choose the protected resources for inclusion in
the group. You can include all resources that have protections, provide
a list of resource Amazon Resource Names (ARNs), or include all
resources of a specified resource type.


=head2 ProtectionGroupArn => Str

The ARN (Amazon Resource Name) of the protection group.


=head2 B<REQUIRED> ProtectionGroupId => Str

The name of the protection group. You use this to identify the
protection group in lists and to manage the protection group, for
example to update, delete, or describe it.


=head2 ResourceType => Str

The resource type to include in the protection group. All protected
resources of this type are included in the protection group. You must
set this when you set C<Pattern> to C<BY_RESOURCE_TYPE> and you must
not set it for any other C<Pattern> setting.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Shield>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

